/*Copyright (c) 2024 Nikos Siatras

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.*/
package Extasys.DataConvertion;

import java.util.Base64;
import java.util.Base64.Decoder;
import java.util.Base64.Encoder;

/**
 *
 * @author Nikos Siatras
 */
public class Base64Converter extends DataConverter
{

    private final Encoder fEncoder;
    private final Decoder fDecoder;

    public Base64Converter()
    {
        fEncoder = Base64.getEncoder();
        fDecoder = Base64.getDecoder();
    }

    /**
     * Encodes all bytes from the specified byte array into a newly-allocated
     * byte array using the Base64 encoding scheme. The returned byte
     * array is of the length of the resulting bytes.
     *
     * @param bytes
     * @return A newly-allocated byte array containing the resulting encoded
     * bytes.
     */
    @Override
    public byte[] Convert(final byte[] bytes)
    {
        return fEncoder.encode(bytes);
    }

    /**
     * Decodes all bytes from the input byte array using the {@link Base64}
     * encoding scheme, writing the results into a newly-allocated output byte
     * array. The returned byte array is of the length of the resulting bytes.
     *
     * @param bytes
     * @return A newly-allocated byte array containing the decoded bytes.
     */
    @Override
    public byte[] Revert(final byte[] bytes)
    {
        return fDecoder.decode(bytes);
    }

}
